classdef EPSSP

   properties
   
      model = "EPSSP"
      version = "1.1.1"
      
   end
   
   methods(Static)
   
      %%%%%%%%%%%%%%%%%%%%%%%
      % Basic communication %
      %%%%%%%%%%%%%%%%%%%%%%%

      function init(ARG)
         % EPSSP.init('192.168.1.100');    opens LAN device
         % EPSSP.init(1);                  opens last USB device
         % EPSSP.init(0);                  shows list of USB devices and lets user chose one
         % EPSSP.init;                     same as eps=EPSSP(1);

         if (nargin<1)
            ARG=1; % connect to last device
         end;
         
         global EPSSPHandle
         if length(ARG)>6&&sum(class(ARG)=='char')==4  % LAN DEVICE
            EPSSPHandle = NOVTCP(ARG);
         else % USB DEVICE
            EPSSPHandle = NOVUSB('LastDevEPSSP.mat', ARG);
         end;
      end;
      
      function close
         global EPSSPHandle
         EPSSPHandle.close
      end;
      
      function [res ok] = read(addr)
         
         global EPSSPHandle
         
         [res ok] = EPSSPHandle.read(addr);
         
         if ok==0, % su success in reading. Try to connect again
            EPSSP.init;
            [res ok] = EPSSPHandle.read(addr);
         end;
         
      end;
      

      function ok = write(addr, data)
      
         global EPSSPHandle
         ok = EPSSPHandle.write(addr, data);
         if ok==0, % su success in writing. Try to connect again
            EPSSP.init;
            [res ok] = EPSSPHandle.write(addr, data);
         end;
         
         % pause to force gap between write commands
         pausetime = 0.0010; % pause 1 ms at FT232R
         mstic=tic;
         mspause=0;
         while mspause<pausetime,
            mspause=toc(mstic);
         end;
         
         
      end;
      
    
      
      %%%%%%%%%%%%%%%%%%%%%%%%%%%
      % General instrument data %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%
      
      function r = getfirmware % as string
         r = sprintf('%4X', EPSSP.read(84));
      end
      
      
      %function r = getserialnumber
      %   r = EPSSP.read(91);
      %end;
      
      %function r = getmoduletype % as string
      %   str=[];
      %   for ii=0:15,
      %      dummy = EPSSP.read(96+ii);
      %      str=[ str char(bitshift(dummy, -8)) ];
      %      str=[ str mod(dummy, 2^8) ];
      %   end;
      %   r = str;
      %end
      
      
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % Device specific functions %
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

      function r = gettemperature
         r = EPSSP.read(60)/16;
      end;
      
      function setval(value) % amplitude as integer 0..2^12-1
         % sets both amplitude and offset
         value = max(0, min(2^12-1, round(value)))
         EPSSP.write(8, value);
      end;
      
      function r = getval % returns amplitude as integer 0..2^12-1
         r = EPSSP.read(8);
      end;

      
      function setamplitude(value) % amplitude as integer 0..2^12-1
         % requires firmware >= 1.0.0.2 and activation by key
         % for security reasons, this key is only avaliable upon request
         value = max(0, min(2^12-1, round(value)));
         EPSSP.write(6, value);
      end;

      function r = getamplitude % returns amplitude as integer 0..2^12-1, either set by setval or setamplitude
         % requires firmware >= 1.0.0.2 
         r = EPSSP.read(6);
      end;


      function setoffset(value) % offset as integer 0..2^12-1
         % requires firmware >= 1.0.0.2 and activation by key
         % for security reasons, this key is only avaliable upon request
         value = max(0, min(2^12-1, round(value)));
         EPSSP.write(7, value);
      end;

      function r = getoffset % returns offset as integer 0..2^12-1, either set by setval or setoffset
         % requires firmware >= 1.0.0.2 
         r = EPSSP.read(7);
      end;
      
      

      
    
      function shutdown(sdn) % 1: shutdown dc-converter
         sdn = max(0, min(1, sdn))
         EPSSP.write(9, sdn);
      end;
      
      function r= getshutdown
         r = EPSSP.read(9);
      end;
      
      
      
      function setnumstates(num) % number of states: 3 or 4
         num = max(3, min(4, num))
         EPSSP.write(10, num);
      end;

      function r = getnumstates 
         r = EPSSP.read(10);
      end;
      
      
      
      function setdirectdata(dd) 
         % if directdata is enabled, input ports "a"
         % are looped through to output ports "b" 
         % default: "00"
         % Bit definitions:
         % Bit 1: "0": directdata defined by input port "directdata_n"
         %        "1": directdata defined by directdata register (Bit 0)
         % Bit 0: "0": directdata register disabled
         %        "1": directdata register enabled
         EPSSP.write(11, dd);
      end;

      function r = getdirectdata 
         r = EPSSP.read(11);
      end;
	  
	  
      function settestpattern(tp0, tp1, tp2, tp3) % also enables testpattern
         % tp0 to tp3 are 3-bit unsigned integer
         % not all 3 bits are available in all versions
         EPSSP.write(110, tp3*2^13 + tp2*2^10 + tp1*2^7 + tp0*2^4 + 1);
      end;
      function disabletestpattern
         tp = EPSSP.read(110);
         EPSSP.write(110, bitand(tp, hex2dec('FFFE')));
	  end;
     
      
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      % INTENSITY MODULATOR VERSION
      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      function setpulsedelay(delay)
         % delay value times 40 ns
         EPSSP.write(101, delay);
      end;
      function r = getpulsedelay
         r = EPSSP.read(101);
      end;
      
      function setpulsewidth(width)
         % width value times 40 ns
         EPSSP.write(102, width);
      end;
      function r = getpulsewidth
         r = EPSSP.read(102);
      end;
      

      
         
      

      
      
      
      
      

   end;

end