from time import sleep
import ftd2xx as ftd
from ctypes import create_string_buffer


class NovoptelUSB():

   
    # Parameters
    baudrate = 230400
    d = None
    
    def __init__(self):
        
        self.isConnected = False
        self.d = None
    
        # list all connected ftdi devices
        dlist=ftd.listDevices(2)
        if len(dlist)>0:
            counter = 0
            for dev in dlist[:]:
                if (len(dev)==0):
                    print("    " + str(counter) + ": " + "<blocked>")
                else:
                    print("    " + str(counter) + ": " + dev.decode('UTF-8'))
                counter = counter + 1
            print("    Select Instrument (-1 to Quit):")
            devicenr = int(input())
            if devicenr>=0:
                self.connect(devicenr)
        else:
             print("    No Instrument found")
        return
        
        
        
    def connect( self, devicenr):
        
        self.d = ftd.open(devicenr)    # Open selected FTDI device
        self.d.setBaudRate(self.baudrate)
        self.d.setDataCharacteristics(8, 0, 0)
        self.d.clrRts()
        #sleep(1)
        self.d.setRts()
        self.d.setDtr()
        self.d.setLatencyTimer(2)
        self.d.purge()
        #sleep(1)
        self.isConnected = True
        print( "Connected." )
        return
        
    def close( self ):
        self.d.close()
        self.isConnected = False
        print( "Closed." )
        return
        
        
    def write(self, addr, data):
        sleep(0.01)
        self.d.purge() # clear buffers
        txstring = 'W' + '{:03X}'.format(addr) + '{:04X}'.format(data) + chr(13)
        tx = create_string_buffer(txstring.encode('utf-8'), 9)
        self.d.write(tx)
        #sleep(0.01)
        return
        
    def read(self, addr):
    
        sleep(0.01)    
        self.d.purge() # clear buffers

        # send request command
        txstring = 'R' + '{:03X}'.format(addr) + '0000' + chr(13)
        #print(txstring)
        tx = create_string_buffer(txstring.encode('utf-8'), 9)
        self.d.write(tx)
        
        # wait for RX
        bytesavailable=0
        tries=0
        while bytesavailable<5 and tries<1000:
            bytesavailable=self.d.getQueueStatus()
            tries += 1
            #sleep(0.001)
        
        # get RX
        res=self.d.read(bytesavailable)
        
        #print(len(res))
        #print(type(res))
        #for ires in res[:]:
        #        print(ires)
        print(tries)
        #print(res.decode("utf-8"))
        #print(int(res.decode("utf-8"),16))
        
        
        # return RX as integer
        if bytesavailable>4:
            val = int(res.decode("utf-8"),16)
        else:
            val = -1     
        return val
        
        
        
        
