import sys
#import struct
#from array import array
#from time import sleep
import numpy as np
import ftd3xx
if sys.platform == 'win32':
    import ftd3xx._ftd3xx_win32 as ft3
elif sys.platform == 'linux2':
    import ftd3xx._ftd3xx_linux as ft3

class NovoptelUSB3():
    
    # Parameters
    DEVNO = -1
    
    def __init__( self ):
    #    return
        
    #def select( self ):
        self.isConnected = False
        self.d=0
        
        # list all connected ftdi3 devices
        dlist=ftd3xx.listDevices(2)
        if dlist is None:
             print("    No Instrument found")
        else:
            counter=0
            for dev in dlist[:]:
                print("    " + str(counter+1) + ": " + dev.decode('UTF-8'))
                counter = counter + 1
            print("    Select Instrument (0 to Quit):")
            self.DEVNO = int(input())-1
            if self.DEVNO>=0:
                self.connect()
        
        return
    
    def connect( self ):
        self.d = ftd3xx.create(self.DEVNO, ft3.FT_OPEN_BY_INDEX)
        if self.d is None:
            print("*** ERROR: Can't find or open Device!")
        else:
            self.isConnected = True
            print( "Connected." )
            #print( "Handle = " + str(self.d.handle) )
    
        return
        
    def close( self ):
        self.d.close()
        self.isConnected = False
        print( "Closed." )
        return
    
    def crc16( self, crc, data):
        for x in data:
            crc = ((crc<<1) | (crc>>15)) & 0xFFFF
            crc ^= x
        return crc
       
    
    def read( self, addr ):
        #reqBuf16 = array('H',[82,addr,0])
        #crc = self.crc16(0xFFFF, reqBuf16)
        ##print("crc = " + str(crc))
        #reqBuf16.append(crc)
        ##print(reqBuf16)
        #sendbytes = bytes(reqBuf16)
        
        reqBuf16 = np.array([82, addr, 0], dtype=np.uint16)
        crc = self.crc16(0xFFFF, reqBuf16)
        reqBuf16 = np.append(reqBuf16, np.uint16(crc))
        
        self.d.writePipe(0x02, reqBuf16.tobytes(), 8)
                
        recvbytes=bytes(8)
        self.d.readPipe(0x82, recvbytes, 8)
        
        #ansBuf16 = struct.unpack('H'*int(len(recvbytes)/2), recvbytes)
        ansBuf16 = np.frombuffer(recvbytes, np.uint16)
        #print(str(ansBuf16))
        
        # CRC check
        crc = self.crc16(crc, np.array([ansBuf16[2]]))
        #print("crc = " + str(crc))
        if crc!=ansBuf16[1]:
            print("*** CRC ERROR during ReadUSB!")
            return 0 
        else:
            return int(ansBuf16[2])
             
        
    def write( self, addr, data ):
        #reqBuf16 = array('H',[87,addr,data])
        #crc = self.crc16(0xFFFF, reqBuf16)
        #reqBuf16.append(crc)
        #sendbytes = bytes(reqBuf16)
        
        reqBuf16 = np.array([87, addr, data], dtype=np.uint16)
        crc = self.crc16(0xFFFF, reqBuf16)
        reqBuf16 = np.append(reqBuf16, np.uint16(crc))
        
        self.d.writePipe(0x02, reqBuf16.tobytes(), 8)
        
        #sleep(0.1)
        
        recvbytes=bytes(8)
        self.d.readPipe(0x82, recvbytes, 8)
        #ansBuf16 = struct.unpack('H'*int(len(recvbytes)/2), recvbytes)
        ansBuf16 = np.frombuffer(recvbytes, np.uint16)
        #print(ansBuf16[0])
        if ansBuf16[0]!=52428:
            print("*** CRC ERROR during WriteUSB!")
            return 0 
        else:
            return 1
        
        
    def setsdramstream(self):
        #reqBuf16 = array('H',[83,0,0]) # 'S'
        #crc = self.crc16(0xFFFF, reqBuf16)
        #reqBuf16.append(crc)
        #sendbytes = bytes(reqBuf16)
        
        reqBuf16 = np.array([83, 0, 0], dtype=np.uint16) # 'S'
        crc = self.crc16(0xFFFF, reqBuf16)
        reqBuf16 = np.append(reqBuf16, np.uint16(crc))
        
        self.d.writePipe(0x02, reqBuf16.tobytes(), 8)
        return
        
    def readstream_raw(self, packetsinthissequence: int):
        self.setsdramstream()
        BytesReq = (packetsinthissequence)*8
        recvbytes = bytes(int(BytesReq))
        self.d.readPipe(0x82, recvbytes, int(BytesReq))
        #print(str(txc))
        #print("numBytesRecv: " % numBytesRecv)
        #ansBuf16 = struct.unpack('H'*int(BytesReq/2), recvbytes)
        #arr = np.array(list(ansBuf16))
        arr = np.frombuffer(recvbytes, np.uint16)
        rows = arr.shape[0] // 4
        if rows * 4 != arr.shape[0]:
            rows -= 1

        arr = arr[0:rows * 4].reshape(rows, 4)
        
        return arr
        
    def readstream(self, startaddr: int, numaddr: int):
        self.write(512+105, int(startaddr) & 0xFFFF)
        self.write(512+106, int(startaddr) >> 16)
        self.write(512+104, 39293) # hsusb reset trigger so that next transfer starts from "startaddr"; also resets the fifo_crc
        
        # always load multiples of 512 addresses bc this is the minimum that HSUSB.vhd will handle!
        #print("numaddr: %d" % numaddr)
        if (int(numaddr) & 0x1FF)>0:
            numaddr = numaddr & 0xFFFFFFFFFFFFFE00
            numaddr = numaddr + 512
            
        data = self.readstream_raw(numaddr)
        return data
        
        
    # Stream transfer; requires firmware > 1.0.8.0
    def readsdram(self, startaddr: int, numaddr: int, normalization=-1):
        # normalization = -1: all as uint16 (for adc data or test counter)
        # normalization =  0: as uint16 (only Stokes 0) and int16 (Stokes 1 to 3)
        # normalization =  1: all as float32, Stokes1 to 3 normalized to 1
        
        buffer_bytes = 2**23
        buffer_addr = buffer_bytes/8
        
        addrtransferred = 0
        curaddr = startaddr
        
        #res = np.empty((0, 4))
        data = np.empty([numaddr, 4], dtype=np.uint16)
        while addrtransferred<numaddr:
            curnumaddr = int(min(buffer_addr, numaddr-addrtransferred))
            
           #data = self.readstream(curaddr, curnumaddr)
           #res = np.concatenate((res, data[:int(curnumaddr),:]), axis=0)
            data[curaddr:(curaddr + curnumaddr), :] = self.readstream(curaddr, curnumaddr) # as uint16           
            
            curaddr = curaddr + curnumaddr
            addrtransferred = addrtransferred + curnumaddr
        
        dout0 = data[0:,0].astype(np.uint16)

        if normalization==0:
            dout1 = data[0:,1] ^ 2**15
            dout2 = data[0:,2] ^ 2**15
            dout3 = data[0:,3] ^ 2**15
            dout1 = dout1.astype(np.int16)
            dout2 = dout2.astype(np.int16)
            dout3 = dout3.astype(np.int16)
        elif normalization==1:
            dout1 = data[0:,1].astype(np.int32)-2**15
            dout2 = data[0:,2].astype(np.int32)-2**15
            dout3 = data[0:,3].astype(np.int32)-2**15
            dout1 = dout1.astype(np.float32)/2**15
            dout2 = dout2.astype(np.float32)/2**15
            dout3 = dout3.astype(np.float32)/2**15
        else:
            dout1 = data[0:,1].astype(np.uint16)
            dout2 = data[0:,2].astype(np.uint16)
            dout3 = data[0:,3].astype(np.uint16)

        return dout0, dout1, dout2, dout3
        
        
    def setsopstream(self, enable: int):
        if (enable>0):
            self.write(512+104, 59362)
            reqBuf16 = array('H',[84,0,0]) # "T"
            crc = self.crc16(0xFFFF, reqBuf16)
            reqBuf16.append(crc)
            sendbytes = bytes(reqBuf16)
            self.d.writePipe(0x02, sendbytes, 8)
        else:
            self.write(512+104, 0)
        
        
    def getsopstream(self, norm: int):
        data=bytes(512)
        numbytes = self.d.readPipe(0x82, data, 512)
        #print("numbytes: %d" % numbytes)
        ansBuf16 = struct.unpack('h'*int(numbytes/2), data[:numbytes])
        arrint16 = np.array(list(ansBuf16))
        rows = numbytes // 8
        arrint16 = arrint16[0:rows * 4].reshape(rows, 4)
        arr = arrint16.astype(float)
        arr[:,0] = arr[:,0]/1000 # convert first row from microwatt to milliwatt
        arr[:,1:] = arr[:,1:]/2**15 # restore normalization
        return arr