import sys
sys.path.append('../Common')
sys.path.append('../Devices')
from PM1000 import PM1000

pm = PM1000('192.168.1.171') # TCP for earlier PM1000s with 100MBit/s LAN interface
#pm = PM1000('UDP192.168.1.70') # UDP for recent PM1000s with 1GBit/s LAN interface
#pm = PM1000('USB2') # USB 2.0 for early PM1000s
#pm = PM1000('USB3') # USB 3.0 using ftd3xx module (abandoned by develpers), with FTDI driver version <= 1.3.0.10
#pm = PM1000('PyD3XX') # USB 3.0 using PyD3XX module, FTDI driver version <= 1.3.0.10



if pm.n is not None:
    
    
    fw = pm.getfirmware()
    print(f"firmware version is {fw}")
    
    sn = pm.getserialnumber()
    print(f"serial number is {sn}")
    
    mt = pm.getmoduletype()
    print(f"module type is {mt}")
    
    pm.setATE(12)
    ATE = pm.getATE()
    print("ATE is %d" % ATE)
    
    
    Stokes = pm.getStokes(norm=1)
    print(f"Current Stokes vector is {Stokes}")
    
    power = pm.getPower()
    print(f"Current power is {power/1000} mW")
    
    
    # record 1024 samples
    pm.setME(10) # Memory Exponent (ME). 2^10 = 1024 Samples
    pm.write(512+74, 0) # set PowExp to 0
    pm.start_recording(0,0,0,0,0,0,0,0)
    pm.waitBusy()
    
    data = pm.getsdram(0, 1024, 1)
    print(data)
   
    pm.close()